package com.biz.crm.sfa.business.template.action.ordinary.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionDisplayExecutePageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionDisplayExecuteVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayExecuteVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 普通活动: ActionDisplayExecuteVo: 陈列活动信息
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionOrdinary/actionDisplayExecute")
@Api(tags = "普通活动: ActionDisplayExecuteVo: 陈列活动信息")
public class ActionDisplayExecuteVoController {

  @Autowired
  private ActionDisplayExecuteVoService actionDisplayExecuteVoService;

  /**
   * 陈列活动执行信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionDisplayExecuteVo> 陈列活动执行信息
   */
  @ApiOperation(value = "陈列活动执行信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<ActionDisplayExecuteVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "ActionDisplayExecutePageDto", value = "分页Dto") ActionDisplayExecutePageDto dto) {
    try {
      return Result.ok(this.actionDisplayExecuteVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过执行ID获取活动执行信息
   *
   * @param id 执行ID
   * @return 活动执行信息
   */
  @ApiOperation(value = "通过执行ID获取活动执行信息")
  @GetMapping("/findById")
  public Result<ActionDisplayExecuteVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.actionDisplayExecuteVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
