package com.biz.crm.sfa.business.template.action.ordinary.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionOrdinaryService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.constant.ActionOrdinaryConstant;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 普通活动: ActionOrdinary: 活动管理
 * 
 * @author ning.zhang
 * @date 2022/8/2
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionOrdinary/actionOrdinary")
@Api(tags = "普通活动: ActionOrdinary: 活动管理")
public class ActionOrdinaryController {

  @Autowired
  private ActionOrdinaryService actionOrdinaryService;
  @Autowired
  private RedisMutexService redisMutexService;
  /**
   * 新增活动信息
   *
   * @param dto 参数dto
   * @return 新增活动数据
   */
  @ApiOperation(value = "新增活动")
  @PostMapping("")
  public Result<ActionOrdinaryEntity> create(@RequestBody ActionOrdinaryDto dto) {
    try {
      return Result.ok(this.actionOrdinaryService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新活动信息
   *
   * @param dto 参数dto
   * @return 更新后活动数据
   */
  @ApiOperation(value = "更新活动信息")
  @PatchMapping("")
  public Result<ActionOrdinaryEntity> update(@RequestBody ActionOrdinaryDto dto) {
    String lockKey = String.format(ActionOrdinaryConstant.ACTION_ORDINARY_CHANGE_LOCK_KEY, dto.getActionCode());
    Validate.isTrue(this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, ActionOrdinaryConstant.ACTION_ORDINARY_TRY_LOCK_OUT_TIME)
        , ActionOrdinaryConstant.ACTION_ORDINARY_LOCK_FAIL_MESSAGE);
    try {
      return Result.ok(this.actionOrdinaryService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(lockKey);
    }
  }

  /**
   * 删除活动
   *
   * @param ids 活动id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.actionOrdinaryService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用活动
   *
   * @param ids 活动id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.actionOrdinaryService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用活动
   *
   * @param ids 活动id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.actionOrdinaryService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
