package com.biz.crm.sfa.business.template.action.ordinary.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionOrdinaryTypeVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 普通活动: ActionOrdinaryTypeVo: 活动类型信息
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionOrdinary/actionOrdinaryType")
@Api(tags = "普通活动: ActionOrdinaryTypeVo: 活动类型信息")
public class ActionOrdinaryTypeVoController {

  @Autowired
  private ActionOrdinaryTypeVoService actionOrdinaryTypeVoService;

  /**
   * 获取所有普通活动类型列表
   *
   * @return 普通活动类型列表
   */
  @ApiOperation(value = "获取所有普通活动类型列表")
  @GetMapping("/findAll")
  public Result<List<ActionOrdinaryTypeVo>> findAll() {
    try {
      return Result.ok(this.actionOrdinaryTypeVoService.findAll());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
