package com.biz.crm.sfa.business.template.action.ordinary.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryPageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionOrdinaryVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 普通活动: ActionOrdinary: 活动管理
 *
 * @author ning.zhang
 * @date 2022/8/2
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionOrdinary/actionOrdinary")
@Api(tags = "普通活动: ActionOrdinaryVo: 活动管理")
public class ActionOrdinaryVoController {

  @Autowired
  private ActionOrdinaryVoService actionOrdinaryVoService;

  /**
   * 活动分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 活动分页数据
   */
  @ApiOperation(value = "活动分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<ActionOrdinaryVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "ActionOrdinaryPageDto", value = "分页Dto") ActionOrdinaryPageDto dto) {
    try {
      return Result.ok(this.actionOrdinaryVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID获取活动详细信息
   *
   * @param id 活动ID
   * @return 活动信息
   */
  @ApiOperation(value = "通过ID获取活动详细信息")
  @GetMapping("/findById")
  public Result<ActionOrdinaryVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.actionOrdinaryVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
