package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 陈列活动采集实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayCollectEntity", description = "陈列活动采集实体类")
@Entity
@TableName("sfa_action_display_collect")
@Table(name = "sfa_action_display_collect", indexes = {
    @Index(name = "sfa_action_display_collect_index1", columnList = "execute_id"),
    @Index(name = "sfa_action_display_collect_index2", columnList = "require_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_display_collect", comment = "陈列活动采集表")
public class ActionDisplayCollectEntity extends UuidOpEntity {

  private static final long serialVersionUID = -1367841722181118932L;

  /**
   * 活动执行ID
   */
  @ApiModelProperty("活动执行ID")
  @Column(name = "execute_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动执行ID'")
  private String executeId;

  /**
   * 要求编码
   */
  @ApiModelProperty("要求编码")
  @Column(name = "require_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '要求编码'")
  private String requireCode;

  /**
   * 要求名称
   */
  @ApiModelProperty("要求名称")
  @Column(name = "require_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '要求名称'")
  private String requireName;

  /**
   * 采集图片
   */
  @ApiModelProperty("采集图片")
  @Transient
  @TableField(exist = false)
  private List<ActionDisplayCollectPictureEntity> pictureList;
}
