package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 陈列活动采集图片实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayCollectPictureEntity", description = "陈列活动采集图片实体类")
@Entity
@TableName("sfa_action_display_collect_picture")
@Table(name = "sfa_action_display_collect_picture", indexes = {
    @Index(name = "sfa_action_display_collect_picture_index1", columnList = "tenant_code"),
    @Index(name = "sfa_action_display_collect_picture_index2", columnList = "collect_id"),
    @Index(name = "sfa_action_display_collect_picture_index3", columnList = "execute_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_display_collect_picture", comment = "陈列活动采集图片表")
public class ActionDisplayCollectPictureEntity extends FileEntity {

  private static final long serialVersionUID = 6130464838553215226L;

  /**
   * 活动执行ID
   */
  @ApiModelProperty("活动执行ID")
  @Column(name = "execute_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动执行ID'")
  private String executeId;

  /**
   * 活动采集ID
   */
  @ApiModelProperty("活动采集ID")
  @Column(name = "collect_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动执行ID'")
  private String collectId;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;
}
