package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 陈列活动实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayEntity", description = "陈列活动实体类")
@Entity
@TableName("sfa_action_display")
@Table(name = "sfa_action_display", indexes = {
    @Index(name = "sfa_action_display_index1", columnList = "tenant_code"),
    @Index(name = "sfa_action_display_index2", columnList = "action_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_display", comment = "陈列活动表")
public class ActionDisplayEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 2223999909537828885L;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  @Column(name = "action_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
  private String actionCode;

  /**
   * 活动频率(天/次)
   */
  @ApiModelProperty("活动频率(天/次)")
  @Column(name = "action_frequency", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '活动频率(天/次)'")
  private Integer actionFrequency;

  /**
   * 最后一次执行日期
   */
  @ApiModelProperty("最后一次执行日期")
  @Column(name = "last_execute_date", length = 20, columnDefinition = "datetime COMMENT '最后一次执行日期 '")
  private Date lastExecuteDate;

  /**
   * 陈列商品
   */
  @ApiModelProperty("陈列商品")
  @Transient
  @TableField(exist = false)
  private List<ActionDisplayProductEntity> productList;
}
