package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 陈列活动执行实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayExecuteEntity", description = "陈列活动执行实体类")
@Entity
@TableName("sfa_action_display_execute")
@Table(name = "sfa_action_display_execute", indexes = {
    @Index(name = "sfa_action_display_execute_index1", columnList = "tenant_code"),
    @Index(name = "sfa_action_display_execute_index2", columnList = "action_code"),
    @Index(name = "sfa_action_display_execute_index3", columnList = "parent_code"),
    @Index(name = "sfa_action_display_execute_index4", columnList = "dynamic_key"),
    @Index(name = "sfa_action_display_execute_index5", columnList = "terminal_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_display_execute", comment = "陈列活动执行表")
public class ActionDisplayExecuteEntity extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = 5108168537814595401L;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  @Column(name = "action_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
  private String actionCode;

  /**
   * 是否已执行(Y:是,N:否)
   */
  @ApiModelProperty("是否已执行(Y:是,N:否)")
  @Column(name = "execute_flag", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '是否已执行(Y:是,N:否)'")
  private String executeFlag;

  /**
   * 执行时间
   */
  @ApiModelProperty("执行时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "execute_date", length = 20, columnDefinition = "datetime COMMENT '执行时间 '")
  private Date executeDate;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @Column(name = "terminal_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @Column(name = "terminal_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '终端名称'")
  private String terminalName;

  /**
   * 提交人账号
   */
  @ApiModelProperty("提交人账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '提交人账号'")
  private String userName;

  /**
   * 提交人姓名
   */
  @ApiModelProperty("提交人姓名")
  @Column(name = "user_real_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '提交人姓名'")
  private String userRealName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  @Column(name = "post_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人职位编码'")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  @Column(name = "post_name", columnDefinition = "varchar(255) COMMENT '提交人职位名称'")
  private String postName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人组织编码")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人组织编码'")
  private String orgCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人组织名称")
  @Column(name = "org_name", columnDefinition = "varchar(255) COMMENT '提交人组织名称'")
  private String orgName;

  /**
   * 活动说明
   */
  @ApiModelProperty("活动说明")
  @Column(name = "action_instruction", columnDefinition = "VARCHAR(255) COMMENT '活动说明'")
  private String actionInstruction;

  /**
   * 采集数据
   */
  @ApiModelProperty("采集数据")
  @Transient
  @TableField(exist = false)
  private List<ActionDisplayCollectEntity> collectList;

}
