package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 陈列活动产品实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayProductEntity", description = "陈列活动产品实体类")
@Entity
@TableName("sfa_action_display_product")
@Table(name = "sfa_action_display_product", indexes = {
    @Index(name = "sfa_action_display_product_index1", columnList = "tenant_code"),
    @Index(name = "sfa_action_display_product_index2", columnList = "display_id"),
    @Index(name = "sfa_action_display_product_index3", columnList = "product_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_display_product", comment = "陈列活动产品表")
public class ActionDisplayProductEntity extends TenantOpEntity {

  private static final long serialVersionUID = 5696984531442132519L;

  /**
   * 陈列活动ID
   */
  @ApiModelProperty("陈列活动ID")
  @Column(name = "display_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '陈列活动ID'")
  private String displayId;

  /**
   * 陈列产品编码
   */
  @ApiModelProperty("陈列产品编码")
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '陈列产品编码'")
  private String productCode;

  /**
   * 最低陈列面数
   */
  @ApiModelProperty("最低陈列面数")
  @Column(name = "surface_number", columnDefinition = "DECIMAL(9,2) COMMENT '最低陈列面数'")
  private BigDecimal surfaceNumber;
}
