package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 普通活动实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionOrdinaryEntity", description = "普通活动实体类")
@Entity
@TableName("sfa_action_ordinary")
@Table(name = "sfa_action_ordinary", indexes = {
    @Index(name = "sfa_action_ordinary_index1", columnList = "tenant_code,action_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_ordinary", comment = "普通活动表")
public class ActionOrdinaryEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 2223999909537828885L;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  @Column(name = "action_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  @Column(name = "action_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动名称'")
  private String actionName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @Column(name = "action_start_date", columnDefinition = "datetime COMMENT '活动开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @Column(name = "action_end_date", columnDefinition = "datetime COMMENT '活动结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * 活动描述
   */
  @ApiModelProperty("活动描述")
  @Column(name = "action_description", columnDefinition = "varchar(255) COMMENT '活动描述'")
  private String actionDescription;

  /**
   * 活动类型key(实现普通活动模块的key值信息)
   */
  @ApiModelProperty("活动类型key(实现普通活动模块的key值信息)")
  @Column(name = "type_key", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '活动类型key(实现普通活动模块的key值信息)'")
  private String typeKey;

  /**
   * 活动要求
   */
  @ApiModelProperty("活动要求")
  @Transient
  @TableField(exist = false)
  private List<ActionOrdinaryRequireEntity> requireList;

  /**
   * 活动范围
   */
  @ApiModelProperty("活动范围")
  @Transient
  @TableField(exist = false)
  private List<ActionOrdinaryScopeEntity> scopeList;

  /**
   * 活动特定信息(实现普通活动的活动特定信息)
   */
  @ApiModelProperty("活动特定信息(实现普通活动的活动特定信息)")
  @Transient
  @TableField(exist = false)
  private JSONObject specificJson;
}
