package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 普通活动要求实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionOrdinaryRequireEntity", description = "普通活动要求实体类")
@Entity
@TableName("sfa_action_ordinary_require")
@Table(name = "sfa_action_ordinary_require", indexes = {
    @Index(name = "sfa_action_ordinary_require_index1", columnList = "action_id"),
    @Index(name = "sfa_action_ordinary_require_index2", columnList = "require_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_ordinary_require", comment = "普通活动要求表")
public class ActionOrdinaryRequireEntity extends TenantOpEntity {

  private static final long serialVersionUID = -563786296758444347L;

  /**
   * 活动ID
   */
  @ApiModelProperty("活动ID")
  @Column(name = "action_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动ID'")
  private String actionId;

  /**
   * 要求编码
   */
  @ApiModelProperty("要求编码")
  @Column(name = "require_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '要求编码'")
  private String requireCode;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;
}
