package com.biz.crm.sfa.business.template.action.ordinary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 普通活动范围实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionOrdinaryScopeEntity", description = "普通活动范围实体类")
@Entity
@TableName("sfa_action_ordinary_scope")
@Table(name = "sfa_action_ordinary_scope", indexes = {
    @Index(name = "sfa_action_ordinary_scope_index1", columnList = "action_id"),
    @Index(name = "sfa_action_ordinary_scope_index2", columnList = "scope_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_ordinary_scope", comment = "普通活动范围表")
public class ActionOrdinaryScopeEntity extends TenantOpEntity {

  private static final long serialVersionUID = 2527401919424105123L;

  /**
   * 活动ID
   */
  @ApiModelProperty("活动ID")
  @Column(name = "action_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动ID'")
  private String actionId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围编码'")
  private String scopeCode;

  /**
   * 范围类型(org:组织范围,channel:渠道范围,client:客户范围)
   *
   * @see ActionOrdinaryScopeType
   */
  @ApiModelProperty("范围类型(org:组织范围,channel:渠道范围,client:客户范围)")
  @Column(name = "scope_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围类型(org:组织范围,channel:渠道范围,client:客户范围)'")
  private String scopeType;


}
