package com.biz.crm.sfa.business.template.action.ordinary.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionOrdinaryConditionModel;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 普通活动表的mybatis-plus接口类 {@link ActionOrdinaryEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:38
 */
public interface ActionOrdinaryMapper extends BaseMapper<ActionOrdinaryEntity> {

  /**
   * 多条件查询普通活动列表
   *
   * @param model 条件model
   * @return 普通活动列表
   */
  List<ActionOrdinaryEntity> findByActionOrdinaryConditionModel(@Param("model") ActionOrdinaryConditionModel model);

  /**
   * 普通活动分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<ActionOrdinaryEntity> 普通活动分页信息
   */
  Page<ActionOrdinaryEntity> findByConditions(Page<ActionOrdinaryEntity> page, @Param("dto") ActionOrdinaryPageDto dto);
}

