package com.biz.crm.sfa.business.template.action.ordinary.local.model;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayCollectVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleTextAreaWidget;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 陈列活动执行表单model
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionDisplayModel", description = "陈列活动执行表单model")
public class ActionDisplayModel extends AbstractDynamicTemplateModel {

  private static final long serialVersionUID = 7368541239113278071L;

  /**
   * 活动执行ID
   */
  @ApiModelProperty("活动执行ID")
  private String executeId;

  /**
   * 活动说明
   */
  @ApiModelProperty("活动说明")
  @DynamicField(fieldName = "活动说明", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleTextAreaWidget.class)
  private String actionInstruction;

  /**
   * 活动采集数据
   */
  @ApiModelProperty("活动采集数据")
  private List<ActionDisplayCollectVo> collectList;
}
