package com.biz.crm.sfa.business.template.action.ordinary.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 普通活动多条件model
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionOrdinaryConditionModel", description = "普通活动多条件model")
public class ActionOrdinaryConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  /**
   * 活动ID集合
   */
  @ApiModelProperty("活动ID集合")
  private Set<String> ids;

  /**
   * 活动编码集合
   */
  @ApiModelProperty("活动编码集合")
  private Set<String> actionCodes;
}
