package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayCollectPictureEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayCollectPictureMapper;
import org.springframework.stereotype.Component;

/**
 * 陈列活动采集图片表的数据库访问类 {@link ActionDisplayCollectPictureEntity}
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:13
 */
@Component
public class ActionDisplayCollectPictureRepository extends ServiceImpl<ActionDisplayCollectPictureMapper, ActionDisplayCollectPictureEntity> {

  /**
   * 通过执行ID删除数据
   *
   * @param executeId 执行ID
   */
  public void deleteByExecuteId(String executeId) {
    this.lambdaUpdate()
        .in(ActionDisplayCollectPictureEntity::getExecuteId, executeId)
        .remove();
  }
}
