package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayCollectEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayCollectMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陈列活动采集表的数据库访问类 {@link ActionDisplayCollectEntity}
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:14
 */
@Component
public class ActionDisplayCollectRepository extends ServiceImpl<ActionDisplayCollectMapper, ActionDisplayCollectEntity> {

  /**
   * 通过执行ID删除数据
   *
   * @param executeId 执行ID
   */
  public void deleteByExecuteId(String executeId) {
    this.lambdaUpdate()
        .in(ActionDisplayCollectEntity::getExecuteId, executeId)
        .remove();
  }
}
