package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayExecuteEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayExecuteMapper;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayExecuteConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陈列活动执行表的数据库访问类 {@link ActionDisplayExecuteEntity}
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:12
 */
@Component
public class ActionDisplayExecuteRepository extends ServiceImpl<ActionDisplayExecuteMapper, ActionDisplayExecuteEntity> {

  /**
   * 根据活动编码集合删除数据
   *
   * @param actionCodes 活动编码集合
   * @param tenantCode 租户编码
   */
  public void deleteByActionCodes(List<String> actionCodes, String tenantCode) {
    this.lambdaUpdate()
        .in(ActionDisplayExecuteEntity::getActionCode, actionCodes)
        .eq(ActionDisplayExecuteEntity::getTenantCode, tenantCode)
        .remove();
  }

  /**
   * 多条件查询陈列活动执行列表
   *
   * @param model 条件model
   * @return 陈列活动执行列表
   */
  public List<ActionDisplayExecuteEntity> findByActionDisplayExecuteConditionModel(ActionDisplayExecuteConditionModel model) {
    return this.baseMapper.findByActionDisplayExecuteConditionModel(model);
  }
}
