package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayExecuteVoMapper;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionDisplayExecutePageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayExecuteVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 陈列活动执行Vo的数据库访问类
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:12
 */
@Component
public class ActionDisplayExecuteVoRepository {

  @Autowired
  private ActionDisplayExecuteVoMapper actionDisplayExecuteVoMapper;

  /**
   * 陈列活动执行信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionDisplayExecuteVo> 陈列活动执行信息
   */
  public Page<ActionDisplayExecuteVo> findByConditions(Pageable pageable, ActionDisplayExecutePageDto dto) {
    Page<ActionDisplayExecuteVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.actionDisplayExecuteVoMapper.findByConditions(page, dto);
  }
}
