package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayProductEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayProductMapper;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 陈列活动产品表的数据库访问类 {@link ActionDisplayProductEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:38
 */
@Component
public class ActionDisplayProductRepository extends ServiceImpl<ActionDisplayProductMapper, ActionDisplayProductEntity> {

  /**
   * 通过陈列活动ID删除数据
   *
   * @param displayIds 陈列活动ID
   */
  public void deleteByDisplayIds(Set<String> displayIds) {
    this.lambdaUpdate()
        .in(ActionDisplayProductEntity::getDisplayId, displayIds)
        .remove();
  }
}
