package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionDisplayMapper;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 普通活动表的数据库访问类 {@link ActionDisplayEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:37
 */
@Component
public class ActionDisplayRepository extends ServiceImpl<ActionDisplayMapper, ActionDisplayEntity> {

  /**
   * 批量删除
   *
   * @param actionCodes 活动编码集合
   * @param tenantCode  租户编码
   */
  public void updateDelFlagByActionCodes(List<String> actionCodes, String tenantCode) {
    this.lambdaUpdate()
        .eq(ActionDisplayEntity::getTenantCode, tenantCode)
        .in(ActionDisplayEntity::getActionCode, actionCodes)
        .set(ActionDisplayEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param actionCodes  活动编码集合
   * @param tenantCode   租户编码
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByActionCodes(List<String> actionCodes, EnableStatusEnum enableStatus, String tenantCode) {
    this.lambdaUpdate()
        .eq(ActionDisplayEntity::getTenantCode, tenantCode)
        .in(ActionDisplayEntity::getActionCode, actionCodes)
        .set(ActionDisplayEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 通过活动编码删除数据
   *
   * @param actionCode 活动编码
   * @param tenantCode 租户编码
   */
  public void deleteByActionCode(String actionCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(ActionDisplayEntity::getActionCode, actionCode)
        .eq(ActionDisplayEntity::getTenantCode, tenantCode)
        .remove();
  }

  /**
   * 多条件查询陈列活动列表
   *
   * @param model 条件model
   * @return 陈列活动列表
   */
  public List<ActionDisplayEntity> findByActionDisplayConditionModel(ActionDisplayConditionModel model) {
    return this.baseMapper.findByActionDisplayConditionModel(model);
  }
}
