package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionOrdinaryMapper;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionOrdinaryConditionModel;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 普通活动表的数据库访问类 {@link ActionOrdinaryEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:38
 */
@Component
public class ActionOrdinaryRepository extends ServiceImpl<ActionOrdinaryMapper, ActionOrdinaryEntity> {

  /**
   * 多条件查询普通活动列表
   *
   * @param model 条件model
   * @return 普通活动列表
   */
  public List<ActionOrdinaryEntity> findByActionOrdinaryConditionModel(ActionOrdinaryConditionModel model) {
    return this.baseMapper.findByActionOrdinaryConditionModel(model);
  }

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(ActionOrdinaryEntity::getId, ids)
        .set(ActionOrdinaryEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(ActionOrdinaryEntity::getId, ids)
        .set(ActionOrdinaryEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 普通活动分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionOrdinaryEntity> 普通活动分页信息
   */
  public Page<ActionOrdinaryEntity> findByConditions(Pageable pageable, ActionOrdinaryPageDto dto) {
    Page<ActionOrdinaryEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
