package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryRequireEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionOrdinaryRequireMapper;
import org.springframework.stereotype.Component;

/**
 * 普通活动要求表的数据库访问类 {@link ActionOrdinaryRequireEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:39
 */
@Component
public class ActionOrdinaryRequireRepository extends ServiceImpl<ActionOrdinaryRequireMapper, ActionOrdinaryRequireEntity> {

  /**
   * 通过普通活动ID删除普通活动要求信息
   *
   * @param actionId 普通活动ID
   */
  public void deleteBySampleId(String actionId) {
    this.lambdaUpdate()
        .eq(ActionOrdinaryRequireEntity::getActionId, actionId)
        .remove();
  }
}
