package com.biz.crm.sfa.business.template.action.ordinary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryScopeEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.mapper.ActionOrdinaryScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 普通活动范围表的数据库访问类 {@link ActionOrdinaryScopeEntity}
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:40
 */
@Component
public class ActionOrdinaryScopeRepository extends ServiceImpl<ActionOrdinaryScopeMapper, ActionOrdinaryScopeEntity> {

  /**
   * 通过普通活动ID删除普通活动范围信息
   *
   * @param actionId 普通活动ID
   */
  public void deleteBySampleId(String actionId) {
    this.lambdaUpdate()
        .eq(ActionOrdinaryScopeEntity::getActionId, actionId)
        .remove();
  }
}
