package com.biz.crm.sfa.business.template.action.ordinary.local.service;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayEntity;

import java.util.List;

/**
 * 陈列活动表服务接口
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:37
 */
public interface ActionDisplayService {

  /**
   * 更新陈列活动
   *
   * @param entity 更新的陈列活动实体
   * @return 陈列活动实体
   */
  ActionDisplayEntity update(ActionDisplayEntity entity);

  /**
   * 批量删除陈列活动
   *
   * @param actionCodes 活动编码集合
   */
  void deleteBatch(List<String> actionCodes);

  /**
   * 批量启用陈列活动
   *
   * @param actionCodes 活动编码集合
   */
  void enableBatch(List<String> actionCodes);

  /**
   * 批量禁用陈列活动
   *
   * @param actionCodes 活动编码集合
   */
  void disableBatch(List<String> actionCodes);

  /**
   * 根据频率生成陈列活动执行记录
   */
  void executeTask();
}
