package com.biz.crm.sfa.business.template.action.ordinary.local.service;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryDto;

import java.util.List;

/**
 * 普通活动表服务接口
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:39
 */
public interface ActionOrdinaryService {

  /**
   * 创建普通活动
   *
   * @param dto 请求参数dto
   * @return 普通活动实体
   */
  ActionOrdinaryEntity create(ActionOrdinaryDto dto);

  /**
   * 更新普通活动
   *
   * @param dto 请求参数dto
   * @return 普通活动实体
   */
  ActionOrdinaryEntity update(ActionOrdinaryDto dto);

  /**
   * 批量删除普通活动
   *
   * @param ids 普通活动id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用普通活动
   *
   * @param ids 普通活动id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用普通活动
   *
   * @param ids 普通活动id集合
   */
  void disableBatch(List<String> ids);

}
