package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayCollectPictureEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayExecuteEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayCollectPictureRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayCollectPictureService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 陈列活动采集图片表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:13
 */
@Slf4j
@Service("actionDisplayCollectPictureService")
public class ActionDisplayCollectPictureServiceImpl implements ActionDisplayCollectPictureService {

  @Autowired
  private ActionDisplayCollectPictureRepository actionDisplayCollectPictureRepository;

  @Override
  @Transactional
  public void update(ActionDisplayExecuteEntity executeEntity) {
    this.createValidation(executeEntity);
    this.actionDisplayCollectPictureRepository.deleteByExecuteId(executeEntity.getId());
    List<ActionDisplayCollectPictureEntity> pictureEntities = executeEntity.getCollectList().stream().flatMap(collectEntity -> collectEntity.getPictureList().stream()).collect(Collectors.toList());
    this.actionDisplayCollectPictureRepository.saveBatch(pictureEntities);
  }

  /**
   * 在创建ActionDisplayCollect模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param executeEntity 检查对象
   */
  private void createValidation(ActionDisplayExecuteEntity executeEntity) {
    Validate.isTrue(!CollectionUtils.isEmpty(executeEntity.getCollectList()), "缺失活动采集数据");
    executeEntity.getCollectList().forEach(collectEntity -> {
      collectEntity.getPictureList().forEach(pictureEntity -> {
        pictureEntity.setId(null);
        pictureEntity.setCollectId(collectEntity.getId());
        pictureEntity.setTenantCode(executeEntity.getTenantCode());
        pictureEntity.setSortIndex(collectEntity.getPictureList().indexOf(pictureEntity) + 1);
        pictureEntity.setExecuteId(executeEntity.getId());
        Validate.notBlank(pictureEntity.getFileCode(), "缺失文件唯一识别号");
      });
    });
  }
}
