package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayExecuteEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayCollectRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayCollectPictureService;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayCollectService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 陈列活动采集表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:14
 */
@Slf4j
@Service("actionDisplayCollectService")
public class ActionDisplayCollectServiceImpl implements ActionDisplayCollectService {

  @Autowired
  private ActionDisplayCollectRepository actionDisplayCollectRepository;
  @Autowired
  private ActionDisplayCollectPictureService actionDisplayCollectPictureService;

  @Override
  @Transactional
  public void update(ActionDisplayExecuteEntity executeEntity) {
    this.createValidation(executeEntity);
    this.actionDisplayCollectRepository.deleteByExecuteId(executeEntity.getId());
    this.actionDisplayCollectRepository.saveBatch(executeEntity.getCollectList());
    this.actionDisplayCollectPictureService.update(executeEntity);
  }

  /**
   * 在创建ActionDisplayCollect模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param executeEntity 检查对象
   */
  private void createValidation(ActionDisplayExecuteEntity executeEntity) {
    Validate.notBlank(executeEntity.getId(), "陈列活动执行信息ID不能为空");
    executeEntity.getCollectList().forEach(entity -> {
      entity.setId(null);
      entity.setExecuteId(executeEntity.getId());
      Validate.notBlank(entity.getRequireCode(), "缺失要求编码");
      Validate.notBlank(entity.getRequireName(), "缺失要求名称");
      Validate.isTrue(!CollectionUtils.isEmpty(entity.getPictureList()), String.format("缺失[%s]图片", entity.getRequireName()));
    });
  }
}
