package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayCollectEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayExecuteEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayModel;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayExecuteRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayCollectService;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayExecuteService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryScopeType;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayCollectVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryScopeVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 陈列活动执行表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-02 15:39:13
 */
@Slf4j
@Service("actionDisplayExecuteService")
public class ActionDisplayExecuteServiceImpl implements ActionDisplayExecuteService {

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ActionDisplayExecuteRepository actionDisplayExecuteRepository;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private ActionDisplayCollectService actionDisplayCollectService;

  @Override
  @Transactional
  public void create(String actionCode, List<ActionOrdinaryScopeVo> scopeList) {
    Validate.notBlank(actionCode, "缺失活动编码");
    Validate.isTrue(!CollectionUtils.isEmpty(scopeList), "缺失活动范围");
    List<TerminalVo> terminalList = this.buildTerminalInfo(scopeList);
    if (!CollectionUtils.isEmpty(terminalList)) {
      List<ActionDisplayExecuteEntity> executeEntities = terminalList.stream().map(terminalVo -> {
        ActionDisplayExecuteEntity entity = new ActionDisplayExecuteEntity();
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setActionCode(actionCode);
        entity.setTerminalCode(terminalVo.getTerminalCode());
        entity.setTerminalName(terminalVo.getTerminalName());
        entity.setExecuteFlag(BooleanEnum.FALSE.getCapital());
        return entity;
      }).collect(Collectors.toList());
      //分批次保存
      List<List<ActionDisplayExecuteEntity>> splitEntities = Lists.partition(executeEntities, 100);
      splitEntities.forEach(entities -> {
        this.actionDisplayExecuteRepository.saveBatch(entities);
      });
    }
  }

  @Override
  @Transactional
  public void update(ActionDisplayModel model) {
    ActionDisplayExecuteEntity entity = this.actionDisplayExecuteRepository.getById(model.getExecuteId());
    Validate.notNull(entity, "陈列活动执行信息不存在!");
    Validate.isTrue(!CollectionUtils.isEmpty(model.getCollectList()), "缺失陈列活动采集数据!");
    entity.setExecuteFlag(BooleanEnum.TRUE.getCapital());
    entity.setTenantCode(TenantUtils.getTenantCode());
    entity.setExecuteDate(new Date());
    entity.setActionInstruction(model.getActionInstruction());
    entity.setParentCode(model.getParentCode());
    entity.setDynamicKey(model.getDynamicKey());
    entity.setDynamicFormCode(model.getDynamicFormCode());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    entity.setUserName(loginDetails.getAccount());
    entity.setUserRealName(loginDetails.getUsername());
    entity.setPostCode(loginDetails.getPostCode());
    entity.setPostName(loginDetails.getPostName());
    entity.setOrgCode(loginDetails.getOrgCode());
    entity.setOrgName(loginDetails.getOrgName());
    this.actionDisplayExecuteRepository.updateById(entity);
    entity.setCollectList((List<ActionDisplayCollectEntity>) this.nebulaToolkitService.copyCollectionByBlankList(model.getCollectList(), ActionDisplayCollectVo.class
        , ActionDisplayCollectEntity.class, HashSet.class, ArrayList.class));
    this.actionDisplayCollectService.update(entity);
  }

  private List<TerminalVo> buildTerminalInfo(List<ActionOrdinaryScopeVo> scopeList) {
    Set<String> terminalCodes = Sets.newHashSet();
    Set<String> orgCodes = Sets.newHashSet();
    Set<String> channels = Sets.newHashSet();
    Map<String, TerminalVo> terminalMap = Maps.newHashMap();
    scopeList.forEach(scopeVo -> {
      if (ActionOrdinaryScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        orgCodes.add(scopeVo.getScopeCode());
      }
      if (ActionOrdinaryScopeType.CHANNEL.getDictCode().equals(scopeVo.getScopeType())) {
        channels.add(scopeVo.getScopeCode());
      }
      if (ActionOrdinaryScopeType.CLIENT.getDictCode().equals(scopeVo.getScopeType())) {
        terminalCodes.add(scopeVo.getScopeCode());
      }
    });
    if (!CollectionUtils.isEmpty(orgCodes)) {
      TerminalSearchDto searchDto = new TerminalSearchDto();
      searchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      searchDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      searchDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
      searchDto.setOrgCodeSet(orgCodes);
      List<TerminalVo> terminalList = this.terminalVoService.findByTerminalSearchDto(searchDto);
      if (!CollectionUtils.isEmpty(terminalList)) {
        terminalList.forEach(terminalVo -> {
          terminalMap.put(terminalVo.getTerminalCode(), terminalVo);
        });
      }
    }
    if (!CollectionUtils.isEmpty(channels)) {
      TerminalSearchDto searchDto = new TerminalSearchDto();
      searchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      searchDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      searchDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
      searchDto.setChannelSet(channels);
      List<TerminalVo> terminalList = this.terminalVoService.findByTerminalSearchDto(searchDto);
      if (!CollectionUtils.isEmpty(terminalList)) {
        terminalList.forEach(terminalVo -> {
          terminalMap.put(terminalVo.getTerminalCode(), terminalVo);
        });
      }
    }
    if (!CollectionUtils.isEmpty(terminalCodes)) {
      TerminalSearchDto searchDto = new TerminalSearchDto();
      searchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      searchDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      searchDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
      searchDto.setTerminalCodeSet(terminalCodes);
      List<TerminalVo> terminalList = this.terminalVoService.findByTerminalSearchDto(searchDto);
      if (!CollectionUtils.isEmpty(terminalList)) {
        terminalList.forEach(terminalVo -> {
          terminalMap.put(terminalVo.getTerminalCode(), terminalVo);
        });
      }
    }
    return Lists.newArrayList(terminalMap.values());
  }
}
