package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayExecuteEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayExecuteConditionModel;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayExecuteRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayExecuteVoRepository;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.constant.ActionOrdinaryConstant;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionDisplayExecutePageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionDisplayExecuteVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionOrdinaryVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayExecuteVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 陈列活动执行Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@Slf4j
@Service
public class ActionDisplayExecuteVoServiceImpl implements ActionDisplayExecuteVoService {

  @Autowired
  private ActionDisplayExecuteVoRepository actionDisplayExecuteVoRepository;
  @Autowired
  private ActionDisplayExecuteRepository actionDisplayExecuteRepository;
  @Autowired
  private ActionOrdinaryVoService actionOrdinaryVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<ActionDisplayExecuteVo> findByConditions(Pageable pageable, ActionDisplayExecutePageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new ActionDisplayExecutePageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setNowDate(new Date());
    if (StringUtils.isNotBlank(dto.getYearMonth())) {
      LocalDate date = LocalDate.of(Integer.parseInt(dto.getYearMonth().substring(0,4))
          , Integer.parseInt(dto.getYearMonth().substring(5,7)), 1);
      //获取当前月的第一天
      LocalDateTime firstDayTime = LocalDateTime.parse(String.format("%s %s",date.with(TemporalAdjusters.firstDayOfMonth()),ActionOrdinaryConstant.TIME_STR_000000), ActionOrdinaryConstant.YYYY_MM_DD_HH_MM_SS);
      //获取当前月的最后一天
      LocalDateTime lastDayTime = LocalDateTime.parse(String.format("%s %s",date.with(TemporalAdjusters.lastDayOfMonth()),ActionOrdinaryConstant.TIME_STR_235959), ActionOrdinaryConstant.YYYY_MM_DD_HH_MM_SS);
      dto.setExecuteStartDate(Date.from(firstDayTime.atZone(ZoneId.systemDefault()).toInstant()));
      dto.setExecuteEndDate(Date.from(lastDayTime.atZone(ZoneId.systemDefault()).toInstant()));
    }
    return this.actionDisplayExecuteVoRepository.findByConditions(pageable, dto);
  }

  @Override
  public ActionDisplayExecuteVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ActionDisplayExecuteConditionModel conditionModel = new ActionDisplayExecuteConditionModel();
    conditionModel.setTenantCode(TenantUtils.getTenantCode());
    conditionModel.setIds(Sets.newHashSet(id));
    List<ActionDisplayExecuteEntity> executeEntities = this.actionDisplayExecuteRepository.findByActionDisplayExecuteConditionModel(conditionModel);
    if (CollectionUtils.isEmpty(executeEntities)) {
      return null;
    }
    ActionDisplayExecuteEntity executeEntity = executeEntities.get(0);
    ActionDisplayExecuteVo executeVo = this.nebulaToolkitService.copyObjectByBlankList(executeEntity, ActionDisplayExecuteVo.class, HashSet.class, ArrayList.class);
    ActionOrdinaryVo actionOrdinaryVo = ObjectUtils.defaultIfNull(this.actionOrdinaryVoService.findByActionCode(executeEntity.getActionCode()), new ActionOrdinaryVo());
    executeVo.setActionName(actionOrdinaryVo.getActionName());
    executeVo.setActionDescription(actionOrdinaryVo.getActionDescription());
    executeVo.setActionStartDate(actionOrdinaryVo.getActionStartDate());
    executeVo.setActionEndDate(actionOrdinaryVo.getActionEndDate());
    executeVo.setRequireList(actionOrdinaryVo.getRequireList());
    ActionDisplayVo actionDisplayVo = Objects.nonNull(actionOrdinaryVo.getSpecificJson())
        ? JsonUtils.json2Obj(actionOrdinaryVo.getSpecificJson().toJSONString(), ActionDisplayVo.class) : new ActionDisplayVo();
    executeVo.setActionFrequency(actionDisplayVo.getActionFrequency());
    executeVo.setProductList(actionDisplayVo.getProductList());
    return executeVo;
  }
}
