package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayProductRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayProductService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 陈列活动产品表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:38
 */
@Slf4j
@Service("actionDisplayProductService")
public class ActionDisplayProductServiceImpl implements ActionDisplayProductService {

  @Autowired
  private ActionDisplayProductRepository actionDisplayProductRepository;

  @Override
  @Transactional
  public void update(ActionDisplayEntity displayEntity) {
    this.updateValidation(displayEntity);
    this.actionDisplayProductRepository.saveBatch(displayEntity.getProductList());
  }

  /**
   * 在修改ActionDisplayProduct模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param displayEntity 检查对象
   */
  private void updateValidation(ActionDisplayEntity displayEntity) {
    Validate.notBlank(displayEntity.getId(), "陈列活动ID不能为空");
    displayEntity.getProductList().forEach(entity -> {
      entity.setId(null);
      entity.setDisplayId(displayEntity.getId());
      entity.setTenantCode(displayEntity.getTenantCode());
      Validate.notBlank(entity.getProductCode(), "缺失陈列产品编码");
      Validate.isTrue(Objects.nonNull(entity.getSurfaceNumber())
          && entity.getSurfaceNumber().compareTo(BigDecimal.ZERO) > 0, "最低陈列面数数据错误");
    });
  }
}
