package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionOrdinaryRequireRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionOrdinaryRequireService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 普通活动要求表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:40
 */
@Slf4j
@Service("actionOrdinaryRequireService")
public class ActionOrdinaryRequireServiceImpl implements ActionOrdinaryRequireService {

  @Autowired
  private ActionOrdinaryRequireRepository actionOrdinaryRequireRepository;

  @Override
  @Transactional
  public void update(ActionOrdinaryEntity ordinaryEntity) {
    this.updateValidation(ordinaryEntity);
    this.actionOrdinaryRequireRepository.deleteBySampleId(ordinaryEntity.getId());
    this.actionOrdinaryRequireRepository.saveBatch(ordinaryEntity.getRequireList());
  }

  /**
   * 在修改ActionOrdinaryRequire模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param ordinaryEntity 检查对象
   */
  private void updateValidation(ActionOrdinaryEntity ordinaryEntity) {
    Validate.notBlank(ordinaryEntity.getId(), "普通活动ID不能为空");
    ordinaryEntity.getRequireList().forEach(entity -> {
      entity.setId(null);
      entity.setActionId(ordinaryEntity.getId());
      entity.setTenantCode(ordinaryEntity.getTenantCode());
      entity.setSortIndex(ordinaryEntity.getRequireList().indexOf(entity) + 1);
      Validate.notBlank(entity.getRequireCode(), "缺失活动要求编码");
    });
  }
}
