package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionOrdinaryScopeRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionOrdinaryScopeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 普通活动范围表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-28 17:56:40
 */
@Slf4j
@Service("actionOrdinaryScopeService")
public class ActionOrdinaryScopeServiceImpl implements ActionOrdinaryScopeService {

  @Autowired
  private ActionOrdinaryScopeRepository actionOrdinaryScopeRepository;

  @Override
  @Transactional
  public void update(ActionOrdinaryEntity ordinaryEntity) {
    this.updateValidation(ordinaryEntity);
    this.actionOrdinaryScopeRepository.deleteBySampleId(ordinaryEntity.getId());
    this.actionOrdinaryScopeRepository.saveBatch(ordinaryEntity.getScopeList());
  }

  /**
   * 在修改ActionOrdinaryScope模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param ordinaryEntity 检查对象
   */
  private void updateValidation(ActionOrdinaryEntity ordinaryEntity) {
    Validate.notBlank(ordinaryEntity.getId(), "普通活动ID不能为空");
    ordinaryEntity.getScopeList().forEach(entity -> {
      entity.setId(null);
      entity.setActionId(ordinaryEntity.getId());
      entity.setTenantCode(ordinaryEntity.getTenantCode());
      Validate.notBlank(entity.getScopeCode(), "缺失活动范围编码");
      Validate.notBlank(entity.getScopeType(), "缺失活动范围类型");
    });
  }
}
