package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;


import com.biz.crm.sfa.business.template.action.ordinary.sdk.register.ActionOrdinaryRegister;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionOrdinaryTypeVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryTypeVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 普通活动类型vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@Slf4j
@Service
public class ActionOrdinaryTypeVoServiceImpl implements ActionOrdinaryTypeVoService {

  @Autowired(required = false)
  private List<ActionOrdinaryRegister> registers;

  @Override
  public List<ActionOrdinaryTypeVo> findAll() {
    if (CollectionUtils.isEmpty(registers)) {
      return Lists.newLinkedList();
    }
    return this.registers.stream().map(register -> {
      ActionOrdinaryTypeVo typeVo = new ActionOrdinaryTypeVo();
      typeVo.setTypeKey(register.getTypeKey());
      typeVo.setTypeName(register.getTypeName());
      return typeVo;
    }).collect(Collectors.toList());
  }
}
