package com.biz.crm.sfa.business.template.action.ordinary.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.data.sample.sdk.service.DataSampleVoService;
import com.biz.crm.sfa.business.data.sample.sdk.vo.DataSampleVo;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionOrdinaryEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionOrdinaryConditionModel;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionOrdinaryRepository;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryPageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryScopeType;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryStatus;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.register.ActionOrdinaryRegister;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.service.ActionOrdinaryVoService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryRequireVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryScopeVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 普通活动vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@Slf4j
@Service
public class ActionOrdinaryVoServiceImpl implements ActionOrdinaryVoService {

  @Autowired
  private ActionOrdinaryRepository actionOrdinaryRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<ActionOrdinaryRegister> registers;
  @Autowired
  private OrgVoService orgVoService;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private DataSampleVoService dataSampleVoService;

  @Override
  public Page<ActionOrdinaryVo> findByConditions(Pageable pageable, ActionOrdinaryPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new ActionOrdinaryPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setNowDate(new Date());
    Page<ActionOrdinaryEntity> entityPage = this.actionOrdinaryRepository.findByConditions(pageable, dto);
    Page<ActionOrdinaryVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    Date nowDate = new Date();
    List<ActionOrdinaryVo> list = entityPage.getRecords().stream().map(ordinaryEntity -> {
      ActionOrdinaryVo actionOrdinaryVo = this.nebulaToolkitService.copyObjectByBlankList(ordinaryEntity, ActionOrdinaryVo.class, HashSet.class, ArrayList.class);
      if (nowDate.getTime() < actionOrdinaryVo.getActionStartDate().getTime()) {
        actionOrdinaryVo.setStatus(ActionOrdinaryStatus.NOT_BEGIN.getDictCode());
      } else if (nowDate.getTime() >= actionOrdinaryVo.getActionStartDate().getTime() && nowDate.getTime() <= actionOrdinaryVo.getActionEndDate().getTime()) {
        actionOrdinaryVo.setStatus(ActionOrdinaryStatus.BEGINNING.getDictCode());
      } else {
        actionOrdinaryVo.setStatus(ActionOrdinaryStatus.END.getDictCode());
      }
      return actionOrdinaryVo;
    }).collect(Collectors.toList());
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public ActionOrdinaryVo findById(String id) {
    if (Objects.isNull(id)) {
      return null;
    }
    ActionOrdinaryConditionModel model = new ActionOrdinaryConditionModel();
    model.setIds(Sets.newHashSet(id));
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<ActionOrdinaryEntity> entities = this.actionOrdinaryRepository.findByActionOrdinaryConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    ActionOrdinaryVo actionOrdinaryVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), ActionOrdinaryVo.class, HashSet.class, ArrayList.class);
    this.buildRequireName(actionOrdinaryVo);
    this.buildScopeName(actionOrdinaryVo);
    this.buildSpecificJson(actionOrdinaryVo);
    return actionOrdinaryVo;
  }

  @Override
  public ActionOrdinaryVo findByActionCode(String actionCode) {
    if (StringUtils.isBlank(actionCode)) {
      return null;
    }
    ActionOrdinaryConditionModel model = new ActionOrdinaryConditionModel();
    model.setActionCodes(Sets.newHashSet(actionCode));
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<ActionOrdinaryEntity> entities = this.actionOrdinaryRepository.findByActionOrdinaryConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    ActionOrdinaryVo actionOrdinaryVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), ActionOrdinaryVo.class, HashSet.class, ArrayList.class);
    this.buildRequireName(actionOrdinaryVo);
    this.buildScopeName(actionOrdinaryVo);
    this.buildSpecificJson(actionOrdinaryVo);
    return actionOrdinaryVo;
  }

  @Override
  public List<ActionOrdinaryVo> findByActionCodes(Set<String> actionCodes) {
    if (CollectionUtils.isEmpty(actionCodes)) {
      return Lists.newLinkedList();
    }
    ActionOrdinaryConditionModel model = new ActionOrdinaryConditionModel();
    model.setActionCodes(actionCodes);
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<ActionOrdinaryEntity> entities = this.actionOrdinaryRepository.findByActionOrdinaryConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    return (List<ActionOrdinaryVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, ActionOrdinaryEntity.class
        , ActionOrdinaryVo.class, HashSet.class, ArrayList.class);
  }



  /**
   * 封装普通活动实现模块特定活动信息
   *
   * @param vo 普通活动Vo
   */
  private void buildSpecificJson(ActionOrdinaryVo vo) {
    if (CollectionUtils.isEmpty(registers)) {
      return;
    }
    this.registers.forEach(register -> {
      if (vo.getTypeKey().equals(register.getTypeKey())) {
        vo.setSpecificJson(register.onRequestByActionCode(vo.getActionCode()));
      }
    });
  }

  /**
   * 封装普通活动要求名称信息
   *
   * @param vo 普通活动Vo
   */
  private void buildRequireName(ActionOrdinaryVo vo) {
    Set<String> requireCodes = vo.getRequireList().stream().map(ActionOrdinaryRequireVo::getRequireCode).collect(Collectors.toSet());
    Map<String, DataSampleVo> dataSampleMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(requireCodes)) {
      List<DataSampleVo> dataSampleList = this.dataSampleVoService.findBySampleCodes(requireCodes);
      if (!CollectionUtils.isEmpty(dataSampleList)) {
        dataSampleMap = dataSampleList.stream().collect(Collectors.toMap(DataSampleVo::getSampleCode, t -> t, (a, b) -> a));
      }
    }
    for (ActionOrdinaryRequireVo requireVo : vo.getRequireList()) {
      requireVo.setRequireName(dataSampleMap.getOrDefault(requireVo.getRequireCode(), new DataSampleVo()).getSampleName());
    }
  }

  /**
   * 封装普通活动范围名称信息
   *
   * @param vo 普通活动Vo
   */
  private void buildScopeName(ActionOrdinaryVo vo) {
    Set<String> orgCodes = Sets.newHashSet();
    Set<String> terminalCodes = Sets.newHashSet();
    vo.getScopeList().forEach(scopeVo -> {
      if (ActionOrdinaryScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        orgCodes.add(scopeVo.getScopeCode());
      }
      if (ActionOrdinaryScopeType.CLIENT.getDictCode().equals(scopeVo.getScopeType())) {
        terminalCodes.add(scopeVo.getScopeCode());
      }
    });
    Map<String, OrgVo> orgMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(orgCodes)) {
      List<OrgVo> orgList = this.orgVoService.findByOrgCodes(Lists.newArrayList(orgCodes));
      if (!CollectionUtils.isEmpty(orgList)) {
        orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> a));
      }
    }
    Map<String, TerminalVo> terminalMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(terminalCodes)) {
      List<TerminalVo> terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(Lists.newLinkedList(), Lists.newArrayList(terminalCodes));
      if (!CollectionUtils.isEmpty(terminalList)) {
        terminalMap = terminalList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, t -> t, (a, b) -> a));
      }
    }
    for (ActionOrdinaryScopeVo scopeVo : vo.getScopeList()) {
      if (ActionOrdinaryScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        scopeVo.setScopeName(orgMap.getOrDefault(scopeVo.getScopeCode(), new OrgVo()).getOrgName());
      }
      if (ActionOrdinaryScopeType.CLIENT.getDictCode().equals(scopeVo.getScopeType())) {
        scopeVo.setScopeName(terminalMap.getOrDefault(scopeVo.getScopeCode(), new TerminalVo()).getTerminalName());
      }
    }
  }
}
