package com.biz.crm.sfa.business.template.action.ordinary.local.service.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.sfa.business.template.action.ordinary.local.entity.ActionDisplayEntity;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayConditionModel;
import com.biz.crm.sfa.business.template.action.ordinary.local.repository.ActionDisplayRepository;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayExecuteService;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayService;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.register.ActionOrdinaryRegister;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayProductVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 普通活动-陈列活动注册实现
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@Component
public class ActionOrdinaryDisplayRegister implements ActionOrdinaryRegister {

  @Autowired
  private ActionDisplayService actionDisplayService;
  @Autowired
  private ActionDisplayRepository actionDisplayRepository;
  @Autowired
  private ProductVoService productVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ActionDisplayExecuteService actionDisplayExecuteService;

  @Override
  public String getTypeKey() {
    return "action_ordinary_display";
  }

  @Override
  public String getTypeName() {
    return "陈列活动";
  }

  @Override
  @Transactional
  public void onCreate(ActionOrdinaryVo vo) {
    if (!vo.getTypeKey().equals(this.getTypeKey())) {
      return;
    }
    Validate.notNull(vo.getSpecificJson(), "缺失陈列信息");
    ActionDisplayEntity actionDisplayEntity = JsonUtils.json2Obj(vo.getSpecificJson().toJSONString(), ActionDisplayEntity.class);
    actionDisplayEntity.setActionCode(vo.getActionCode());
    //活动已开始生成执行信息
    long nowTime = System.currentTimeMillis();
    if (vo.getActionStartDate().getTime() <= nowTime && vo.getActionEndDate().getTime() >= nowTime) {
      this.actionDisplayExecuteService.create(vo.getActionCode(), vo.getScopeList());
      actionDisplayEntity.setLastExecuteDate(new Date());
    }
    this.actionDisplayService.update(actionDisplayEntity);
  }

  @Override
  @Transactional
  public void onUpdate(ActionOrdinaryVo oldVo, ActionOrdinaryVo newVo) {
    if (!(newVo.getTypeKey().equals(this.getTypeKey()) && oldVo.getTypeKey().equals(this.getTypeKey()))) {
      return;
    }
    Validate.notNull(newVo.getSpecificJson(), "缺失陈列信息");
    ActionDisplayEntity actionDisplayEntity = JsonUtils.json2Obj(newVo.getSpecificJson().toJSONString(), ActionDisplayEntity.class);
    actionDisplayEntity.setActionCode(newVo.getActionCode());
    //活动已开始生成执行信息
    long nowTime = System.currentTimeMillis();
    if (newVo.getActionStartDate().getTime() <= nowTime && newVo.getActionEndDate().getTime() >= nowTime) {
      this.actionDisplayExecuteService.create(newVo.getActionCode(), newVo.getScopeList());
      actionDisplayEntity.setLastExecuteDate(new Date());
    }
    this.actionDisplayService.update(actionDisplayEntity);
  }

  @Override
  @Transactional
  public void onDisable(List<ActionOrdinaryVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> actionCodes = voList.stream().filter(actionOrdinaryVo -> actionOrdinaryVo.getTypeKey().equals(this.getTypeKey()))
        .map(ActionOrdinaryVo::getActionCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(actionCodes)) {
      return;
    }
    this.actionDisplayService.disableBatch(actionCodes);
  }

  @Override
  @Transactional
  public void onEnable(List<ActionOrdinaryVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> actionCodes = voList.stream().filter(actionOrdinaryVo -> actionOrdinaryVo.getTypeKey().equals(this.getTypeKey()))
        .map(ActionOrdinaryVo::getActionCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(actionCodes)) {
      return;
    }
    this.actionDisplayService.enableBatch(actionCodes);
  }

  @Override
  @Transactional
  public void onDelete(List<ActionOrdinaryVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> actionCodes = voList.stream().filter(actionOrdinaryVo -> actionOrdinaryVo.getTypeKey().equals(this.getTypeKey()))
        .map(ActionOrdinaryVo::getActionCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(actionCodes)) {
      return;
    }
    this.actionDisplayService.deleteBatch(actionCodes);
  }

  @Override
  public JSONObject onRequestByActionCode(String actionCode) {
    ActionDisplayConditionModel conditionModel = new ActionDisplayConditionModel();
    conditionModel.setTenantCode(TenantUtils.getTenantCode());
    conditionModel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    conditionModel.setActionCodes(Sets.newHashSet(actionCode));
    List<ActionDisplayEntity> entities = this.actionDisplayRepository.findByActionDisplayConditionModel(conditionModel);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    ActionDisplayVo actionDisplayVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), ActionDisplayVo.class, HashSet.class, ArrayList.class);
    if (!CollectionUtils.isEmpty(actionDisplayVo.getProductList())) {
      Set<String> productCodes = actionDisplayVo.getProductList().stream().map(ActionDisplayProductVo::getProductCode).collect(Collectors.toSet());
      List<ProductVo> productList = this.productVoService.findDetailsByIdsOrProductCodes(Lists.newArrayList(), Lists.newArrayList(productCodes));
      if (!CollectionUtils.isEmpty(productList)) {
        Map<String, ProductVo> productMap = productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, t -> t, (a, b) -> a));
        actionDisplayVo.getProductList().forEach(displayProductVo -> {
          ProductVo productVo = productMap.getOrDefault(displayProductVo.getProductCode(), new ProductVo());
          displayProductVo.setProductName(productVo.getProductName());
          displayProductVo.setProductLevelCode(productVo.getProductLevelCode());
          displayProductVo.setProductLevelName(productVo.getProductLevelName());
        });
      }
    }
    return JsonUtils.toJSONObject(actionDisplayVo);
  }
}
