package com.biz.crm.sfa.business.template.action.ordinary.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayModel;
import com.biz.crm.sfa.business.template.action.ordinary.local.service.ActionDisplayExecuteService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 专门为具体的TPM活动执行业务模型服务的操作策略
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@Component
@Slf4j
public class DynamicFormOperationStrategyForActionDisplayModel implements DynamicFormOperationStrategy<ActionDisplayModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;
  @Autowired
  private ActionDisplayExecuteService actionDisplayExecuteService;

  @Override
  public int getOrder() {
    return 11;
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "陈列活动执行";
  }

  @Override
  public Class<ActionDisplayModel> dynamicFormClass() {
    return ActionDisplayModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    log.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormCreate(ActionDisplayModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    this.actionDisplayExecuteService.update(dynamicForm);
  }

  @Override
  public void onDynamicFormModify(ActionDisplayModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    throw new IllegalArgumentException("不支持修改操作");
  }

  @Override
  public ActionDisplayModel findByParentCode(String dynamicKey, String parentCode) {
    //由于详情页面数据复杂,所有不提供通用的详情查询接口
    return null;
  }
}
