package com.biz.crm.sfa.business.template.action.ordinary.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.action.ordinary.local.model.ActionDisplayModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * TPM活动执行表单模板操作策略实现类
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@Component
public class DynamicTemplateOperationStrategyForActionDisplayModel implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForActionDisplayModel dynamicFormOperationStrategyForActionDisplayModel;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForActionDisplayModel.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    ActionDisplayModel model = JsonUtils.json2Obj(jsonObject.toJSONString(), ActionDisplayModel.class);
    this.dynamicFormOperationStrategyForActionDisplayModel.onDynamicFormCreate(model, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    ActionDisplayModel model = JsonUtils.json2Obj(jsonObject.toJSONString(), ActionDisplayModel.class);
    this.dynamicFormOperationStrategyForActionDisplayModel.onDynamicFormModify(model, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForActionDisplayModel.findByParentCode(dynamicKey, parentCode);
  }
}
