package com.biz.crm.sfa.business.template.action.ordinary.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.format.DateTimeFormatter;

/**
 * 普通活动常量类
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ActionOrdinaryConstant {

  /**
   * 普通活动变动锁key
   */
  public static final String ACTION_ORDINARY_CHANGE_LOCK_KEY = "actionOrdinaryChangeLock_%s";

  /**
   * 普通活动获取锁超时时间
   */
  public static final Integer ACTION_ORDINARY_TRY_LOCK_OUT_TIME = 20;

  /**
   * 普通活动获取锁失败提示
   */
  public static final String ACTION_ORDINARY_LOCK_FAIL_MESSAGE = "存在进行中关联操作,请稍后再试!";

  /**
   * 时间日期格式 yyyy-MM-dd HH:mm:ss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

  /**
   * 每天最早的时刻
   */
  public static final String TIME_STR_000000 = "00:00:00";

  /**
   * 每天最晚的时刻
   */
  public static final String TIME_STR_235959 = "23:59:59";
}
