package com.biz.crm.sfa.business.template.action.ordinary.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionDisplayStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 陈列活动执行信息Vo
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionDisplayExecuteVo", description = "陈列活动执行信息Vo")
public class ActionDisplayExecutePageDto extends TenantDto {

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  private String actionName;

  /**
   * 查询年月(yyyy-MM)
   */
  @ApiModelProperty("查询年月(yyyy-MM)")
  private String yearMonth;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 活动状态
   *
   * @see ActionDisplayStatus
   */
  @ApiModelProperty("活动状态")
  private String status;

  /**
   * 当前时间,配合status使用
   */
  @ApiModelProperty(value = "当前时间,配合status使用", hidden = true)
  private Date nowDate;

  /**
   * 执行开始时间
   */
  @ApiModelProperty(value = "执行开始时间", hidden = true)
  private Date executeStartDate;

  /**
   * 执行结束时间
   */
  @ApiModelProperty(value = "执行结束时间", hidden = true)
  private Date executeEndDate;
}
