package com.biz.crm.sfa.business.template.action.ordinary.sdk.dto;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 普通活动dto
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionOrdinaryDto", description = "普通活动dto")
public class ActionOrdinaryDto extends TenantDto {

  /**
   * 活动类型key(实现普通活动模块的key值信息)
   */
  @ApiModelProperty("活动类型key(实现普通活动模块的key值信息)")
  private String typeKey;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  private String actionName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * 活动描述
   */
  @ApiModelProperty("活动描述")
  private String actionDescription;

  /**
   * 活动要求
   */
  @ApiModelProperty("活动要求")
  private List<ActionOrdinaryRequireDto> requireList;

  /**
   * 活动范围
   */
  @ApiModelProperty("活动范围")
  private List<ActionOrdinaryScopeDto> scopeList;

  /**
   * 活动特定信息(实现普通活动的活动特定信息)
   */
  @ApiModelProperty("活动特定信息(实现普通活动的活动特定信息)")
  private JSONObject specificJson;
}
