package com.biz.crm.sfa.business.template.action.ordinary.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 普通活动分页查询dto
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionOrdinaryDto", description = "普通活动分页查询dto")
public class ActionOrdinaryPageDto extends TenantFlagOpDto {

  /**
   * 活动类型key(实现普通活动模块的key值信息)
   */
  @ApiModelProperty("活动类型key(实现普通活动模块的key值信息)")
  private String typeKey;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  private String actionName;

  /**
   * 活动状态
   *
   * @see ActionOrdinaryStatus
   */
  @ApiModelProperty("活动状态")
  private String status;

  /**
   * 当前时间,配合status使用
   */
  @ApiModelProperty(value = "当前时间,配合status使用", hidden = true)
  private Date nowDate;
}
