package com.biz.crm.sfa.business.template.action.ordinary.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 普通活动范围dto
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionOrdinaryScopeDto", description = "普通活动范围dto")
public class ActionOrdinaryScopeDto extends TenantDto {

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围类型(org:组织范围,channel:渠道范围,client:客户范围)
   *
   * @see ActionOrdinaryScopeType
   */
  @ApiModelProperty("范围类型(org:组织范围,channel:渠道范围,client:客户范围)")
  private String scopeType;
}
