package com.biz.crm.sfa.business.template.action.ordinary.sdk.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;

import java.util.List;

/**
 * 普通活动注册器(实现了普通活动的模块需要实现此接口实现模块注册和增删改查的关联操作)
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
public interface ActionOrdinaryRegister {

  /**
   * 获取实现模块key值
   *
   * @return 模块key值
   */
  String getTypeKey();

  /**
   * 获取实现模块名称
   *
   * @return 模块名称
   */
  String getTypeName();

  /**
   * 当普通活动新增时触发
   *
   * @param vo 普通活动信息
   */
  void onCreate(ActionOrdinaryVo vo);

  /**
   * 当普通活动修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(ActionOrdinaryVo oldVo, ActionOrdinaryVo newVo);

  /**
   * 当普通活动禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<ActionOrdinaryVo> voList);

  /**
   * 当普通活动启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<ActionOrdinaryVo> voList);

  /**
   * 当普通活动删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<ActionOrdinaryVo> voList);

  /**
   * 通过普通活动编码获取实现模块的特定活动信息
   *
   * @param actionCode 普通活动编码
   * @return 实现模块的特定活动信息
   */
  JSONObject onRequestByActionCode(String actionCode);
}
