package com.biz.crm.sfa.business.template.action.ordinary.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionDisplayExecutePageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionDisplayExecuteVo;
import org.springframework.data.domain.Pageable;

/**
 * 陈列活动执行Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
public interface ActionDisplayExecuteVoService {

  /**
   * 陈列活动执行信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionDisplayExecuteVo> 陈列活动执行信息
   */
  Page<ActionDisplayExecuteVo> findByConditions(Pageable pageable, ActionDisplayExecutePageDto dto);

  /**
   * 通过执行ID获取活动执行信息
   *
   * @param id 执行ID
   * @return 活动执行信息
   */
  ActionDisplayExecuteVo findById(String id);
}
