package com.biz.crm.sfa.business.template.action.ordinary.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.dto.ActionOrdinaryPageDto;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.vo.ActionOrdinaryVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 普通活动vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
public interface ActionOrdinaryVoService {

  /**
   * 普通活动分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionOrdinaryVo> 普通活动分页信息
   */
  Page<ActionOrdinaryVo> findByConditions(Pageable pageable, ActionOrdinaryPageDto dto);

  /**
   * 通过ID查询普通活动信息
   *
   * @param id ID
   * @return 普通活动信息
   */
  ActionOrdinaryVo findById(String id);

  /**
   * 通过活动编码查询普通活动信息
   *
   * @param actionCode 活动编码
   * @return 普通活动信息
   */
  ActionOrdinaryVo findByActionCode(String actionCode);

  /**
   * 通过活动编码集合获取普通活动信息
   *
   * @param actionCodes 活动编码集合
   * @return 普通活动信息
   */
  List<ActionOrdinaryVo> findByActionCodes(Set<String> actionCodes);
}
