package com.biz.crm.sfa.business.template.action.ordinary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionDisplayStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 陈列活动执行信息Vo
 *
 * @author ning.zhang
 * @date 2022/8/3
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionDisplayExecuteVo", description = "陈列活动执行信息Vo")
public class ActionDisplayExecuteVo extends TenantOpVo {

  private static final long serialVersionUID = -8511065431207347324L;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  private String actionName;

  /**
   * 活动描述
   */
  @ApiModelProperty("活动描述")
  private String actionDescription;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 活动频率(天/次)
   */
  @ApiModelProperty("活动频率(天/次)")
  private Integer actionFrequency;

  /**
   * 活动状态
   *
   * @see ActionDisplayStatus
   */
  @ApiModelProperty("活动状态")
  private String status;

  /**
   * 执行时间
   */
  @ApiModelProperty("执行时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date executeDate;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * 提交人账号
   */
  @ApiModelProperty("提交人账号")
  private String userName;

  /**
   * 提交人姓名
   */
  @ApiModelProperty("提交人姓名")
  private String userRealName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  private String postName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人组织编码")
  private String orgCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人组织名称")
  private String orgName;

  /**
   * 活动说明
   */
  @ApiModelProperty("活动说明")
  private String actionInstruction;

  /**
   * 陈列商品
   */
  @ApiModelProperty("陈列商品")
  private List<ActionDisplayProductVo> productList;

  /**
   * 活动要求
   */
  @ApiModelProperty("活动要求")
  private List<ActionOrdinaryRequireVo> requireList;

  /**
   * 活动采集数据
   */
  @ApiModelProperty("活动采集数据")
  private List<ActionDisplayCollectVo> collectList;
}
