package com.biz.crm.sfa.business.template.action.ordinary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 陈列活动产品vo
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionDisplayProductVo", description = "陈列活动产品vo")
public class ActionDisplayProductVo extends TenantOpVo {

  private static final long serialVersionUID = -3007442515703397394L;

  /**
   * 陈列活动ID
   */
  @ApiModelProperty("陈列活动ID")
  private String displayId;

  /**
   * 陈列产品编码
   */
  @ApiModelProperty("陈列产品编码")
  private String productCode;

  /**
   * 陈列产品名称
   */
  @ApiModelProperty("陈列产品名称")
  private String productName;

  /**
   * 陈列产品级别编码
   */
  @ApiModelProperty("陈列产品级别编码")
  private String productLevelCode;

  /**
   * 陈列产品级别名称
   */
  @ApiModelProperty("陈列产品级别名称")
  private String productLevelName;

  /**
   * 最低陈列面数
   */
  @ApiModelProperty("最低陈列面数")
  private BigDecimal surfaceNumber;
}
