package com.biz.crm.sfa.business.template.action.ordinary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 陈列活动Vo
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionDisplayVo", description = "陈列活动Vo")
public class ActionDisplayVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -8511065431207347324L;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String actionCode;

  /**
   * 活动频率(天/次)
   */
  @ApiModelProperty("活动频率(天/次)")
  private Integer actionFrequency;

  /**
   * 陈列商品
   */
  @ApiModelProperty("陈列商品")
  private List<ActionDisplayProductVo> productList;
}
