package com.biz.crm.sfa.business.template.action.ordinary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 普通活动要求Vo
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionOrdinaryRequireVo", description = "普通活动要求Vo")
public class ActionOrdinaryRequireVo extends TenantOpVo {

  private static final long serialVersionUID = -3145856033416547804L;

  /**
   * 要求编码
   */
  @ApiModelProperty("要求编码")
  private String requireCode;

  /**
   * 要求名称
   */
  @ApiModelProperty("要求名称")
  private String requireName;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  private Integer sortIndex;
}
